VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.Form Form1 
   BackColor       =   &H00C0FFC0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "LAN Waveform Viewer (V1.4)"
   ClientHeight    =   7725
   ClientLeft      =   2385
   ClientTop       =   2355
   ClientWidth     =   9405
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   9
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   7725
   ScaleWidth      =   9405
   Begin VB.TextBox Text2 
      Height          =   330
      Left            =   7920
      TabIndex        =   22
      Top             =   6360
      Width           =   735
   End
   Begin VB.TextBox Text1 
      Height          =   330
      Left            =   7680
      TabIndex        =   20
      Top             =   5280
      Width           =   1215
   End
   Begin VB.CommandButton Get_IQ_Data 
      Caption         =   "Get  IQ Data"
      Height          =   375
      Left            =   7560
      TabIndex        =   19
      ToolTipText     =   "IQ Data = Real(Single)"
      Top             =   4080
      Width           =   1455
   End
   Begin RichTextLib.RichTextBox RichTextBox2 
      Height          =   3015
      Left            =   3720
      TabIndex        =   16
      Top             =   4200
      Width           =   3135
      _ExtentX        =   5530
      _ExtentY        =   5318
      _Version        =   393217
      Enabled         =   -1  'True
      ScrollBars      =   2
      TextRTF         =   $"Form1.frx":0442
   End
   Begin RichTextLib.RichTextBox RichTextBox1 
      Height          =   3015
      Left            =   360
      TabIndex        =   15
      Top             =   4200
      Width           =   3135
      _ExtentX        =   5530
      _ExtentY        =   5318
      _Version        =   393217
      Enabled         =   -1  'True
      ScrollBars      =   2
      TextRTF         =   $"Form1.frx":04CF
   End
   Begin VB.CheckBox chkMon 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Monitor"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   13
      Top             =   1800
      Width           =   1035
   End
   Begin VB.CommandButton cmdEnd 
      BackColor       =   &H00C0C0FF&
      Caption         =   "EXIT"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   5640
      Style           =   1  'Graphical
      TabIndex        =   12
      ToolTipText     =   "Exit the program"
      Top             =   1320
      Width           =   1215
   End
   Begin VB.CommandButton cmdTrace 
      BackColor       =   &H0080FF80&
      Caption         =   "Waveform View"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   675
      Left            =   7320
      Style           =   1  'Graphical
      TabIndex        =   11
      ToolTipText     =   "Run FUS monitor"
      Top             =   840
      Width           =   1755
   End
   Begin VB.ListBox lstRecv 
      BeginProperty Font 
         Name            =   "lr oSVbN"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1500
      ItemData        =   "Form1.frx":055C
      Left            =   240
      List            =   "Form1.frx":055E
      TabIndex        =   7
      Top             =   2100
      Width           =   7095
   End
   Begin ComctlLib.StatusBar sbrMessage 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   6
      Top             =   7410
      Width           =   9405
      _ExtentX        =   16589
      _ExtentY        =   556
      Style           =   1
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdDisConn 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Close"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   5640
      Style           =   1  'Graphical
      TabIndex        =   5
      ToolTipText     =   "Disconnect with FUS"
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "SendText"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   3960
      TabIndex        =   4
      ToolTipText     =   "Sending a command to FUS"
      Top             =   1320
      Width           =   1215
   End
   Begin VB.CommandButton cmdConnect 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Connect"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   3960
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   "Connect with FUS"
      Top             =   600
      Width           =   1215
   End
   Begin VB.TextBox txtPort 
      BeginProperty Font 
         Name            =   "lr oSVbN"
         Size            =   9
         Charset         =   128
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   270
      Left            =   2760
      TabIndex        =   2
      Text            =   "5025"
      Top             =   600
      Width           =   735
   End
   Begin VB.TextBox txtSend 
      BeginProperty Font 
         Name            =   "lr oSVbN"
         Size            =   9
         Charset         =   128
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   270
      Left            =   240
      TabIndex        =   1
      Text            =   "*IDN?"
      Top             =   1320
      Width           =   3255
   End
   Begin VB.TextBox txtHost 
      BeginProperty Font 
         Name            =   "lr oSVbN"
         Size            =   9
         Charset         =   128
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Text            =   "192.168.0.1"
      Top             =   600
      Width           =   2115
   End
   Begin MSWinsockLib.Winsock tcpClient 
      Left            =   7920
      Top             =   120
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Label Label7 
      BackColor       =   &H00C0FFC0&
      Caption         =   "(Option)"
      Height          =   255
      Left            =   7920
      TabIndex        =   24
      Top             =   4440
      Width           =   855
   End
   Begin VB.Line Line4 
      BorderColor     =   &H80000001&
      X1              =   7200
      X2              =   7200
      Y1              =   3840
      Y2              =   7200
   End
   Begin VB.Line Line1 
      BorderColor     =   &H80000001&
      X1              =   120
      X2              =   9240
      Y1              =   3840
      Y2              =   3840
   End
   Begin VB.Label Label6 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Display Steps:"
      Height          =   255
      Left            =   7800
      TabIndex        =   23
      Top             =   6120
      Width           =   1215
   End
   Begin VB.Label Label5 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Samples:"
      Height          =   255
      Left            =   7920
      TabIndex        =   21
      Top             =   5040
      Width           =   855
   End
   Begin VB.Label Label4 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Q Data :"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3840
      TabIndex        =   18
      Top             =   3960
      Width           =   855
   End
   Begin VB.Label Label3 
      BackColor       =   &H00C0FFC0&
      Caption         =   "I Data :"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   480
      TabIndex        =   17
      Top             =   3960
      Width           =   855
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "U3700 Waveform Viewer via LAN"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   14.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   315
      Left            =   2040
      TabIndex        =   14
      Top             =   60
      Width           =   5355
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Sending Text:"
      Height          =   195
      Index           =   2
      Left            =   240
      TabIndex        =   10
      Top             =   1080
      Width           =   1335
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Port No."
      Height          =   195
      Index           =   1
      Left            =   2760
      TabIndex        =   9
      Top             =   360
      Width           =   855
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Host Address:"
      Height          =   195
      Index           =   0
      Left            =   240
      TabIndex        =   8
      Top             =   360
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'*----------------------------------------------------------------------
'*.Program Name :        LAN Remote SPA Viewer
'*
'*      Sample software for Advantest Spectrum Analyzer U37xx
'*
'*.Description :
'*
'*.Revision History :
'*      1.00           1-JAN-2006       First Release. by Ogino
'*      1.40           1-Mar-2010       1.4   Release. by Hirakoso
'*                                            Add IQ-data reading
'*
'*----------------------------------------------------------------------
'*.Copyright(c) 2006,2010 ADVANTEST CORPORATION
'*.http://www.advantest.co.jp
'*----------------------------------------------------------------------


Const CMD_CONN As String = "1,"
Const CMD_DISCONN As String = "2,"
Const CMD_CONTON As String = "3,"
Const CMD_CONTOFF As String = "4,"
Const CMD_DATA As String = "5,"
Dim repData As String
Dim exitFg As Integer



Private Sub cmdEnd_Click()
Dim i
    exitFg = 1
    Debug.Print "Forms", Forms.Count
    For i = 0 To Forms.Count - 1
        Unload Forms(i)
    Next i
    
    SetupLAN = 0

End Sub



Private Sub cmdDisConn_Click()
    Dim ErrRet As Integer

    ErrRet = SendDtFunc("GTL" & vbLf)
    sbrMessage.SimpleText = "Closing..."
    tcpClient.Close
    sbrMessage.SimpleText = "Closed"
        
    cmdConnect.Enabled = True
    cmdConnect.Default = True
    cmdDisConn.Enabled = False
    
    txtHost.Enabled = True
    txtPort.Enabled = True
    txtHost.SetFocus
    
    SetupLAN = 0
    
End Sub



Private Sub cmdConnect_Click()
Dim Sp As String
Dim SendDt As String, ErrRet As Integer
    
    If Trim$(txtHost.Text) <> "" And _
      Trim$(txtPort.Text) <> "" Then
    'AvP[Vɐڑv𑗐M܂
        tcpClient.Protocol = sckTCPProtocol
        tcpClient.LocalPort = 0
        tcpClient.RemoteHost = txtHost.Text
        tcpClient.RemotePort = txtPort.Text
        tcpClient.Connect
        sbrMessage.SimpleText = "Connecting..."
            
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
        Loop
        tcpClient.GetData Sp
        lstRecv.AddItem tcpClient.RemoteHost & "-->" & Sp
        ErrRet = SendDtFunc("REN" & vbLf)

        cmdTrace.Default = True
        cmdDisConn.Enabled = True
        cmdConnect.Enabled = False
        
        SetupLAN = 1
        
    Else

        MsgBox "Please input the IP Address"
        SetupLAN = 0
        
    End If
    
    RichTextBox1.Text = ""
    RichTextBox2.Text = ""
    
    
End Sub



Private Sub cmdSend_Click()
Dim SendDt As String, ErrRet As Integer
Dim RcvDt As String
Dim dTimer As Double, iErrFg As Integer


If SetupLAN = 1 Then

    ErrRet = SendDtFunc("REN")              'Remote setting
    If ErrRet <> 0 Then Exit Sub
                                            'SendDt = CMD_DATA + txtSend.Text
    SendDt = txtSend.Text
    ErrRet = SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    iErrFg = 0
    dTimer = Timer
    If InStr(SendDt, "?") > 0 Then
'        ErrRet = SendDtFunc(SendDt)
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
            If Timer > dTimer + 10# Then
                iErrFg = 1
                Exit Do
            End If
        Loop
        If iErrFg = 0 Then
            tcpClient.GetData RcvDt
            lstRecv.AddItem tcpClient.RemoteHost & "-->" & RcvDt
        Else
            lstRecv.AddItem tcpClient.RemoteHost & "-->" & "Query error!"
        End If
        lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
   End If
   
Else

    MsgBox "Please open the LAN: Connect button..."

End If

End Sub


Private Sub cmdTrace_Click()

If SetupLAN = 1 Then

    DispForm.Show vbModal
    
Else

    MsgBox "Please open the LAN: Connect button..."

End If


End Sub


Private Sub Form_Load()

exitFg = 0
SizeValue = 0
DataGetFg = False   'DataǂłȂ
GridType = 0        '
GridDivX = 10       '10
GridDivY = 10       'c10

'DispForm.Show

cmdDisConn.Enabled = False

End Sub


Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
If exitFg <> 0 Then Exit Sub

MsgBox "Use EXIT button for quit.", vbOKOnly, App.Title
Cancel = -1
End Sub


Private Sub Form_Unload(Cancel As Integer)
End
End Sub


Private Sub Get_IQ_Data_Click()

Dim TrIQ(1070002, 1) As Single
Dim IQptsbuf As String
Dim IQpts As Long, i As Long, DataCnt As Long
Dim DspStep As Integer
Dim bTrc() As Byte
Dim TempBuf As Byte


If SetupLAN = 1 Then

    Call SendDtFunc("REN")                      'Set remote
    
    Call SendDtFunc("AW; BW")                   'A,B Trace ON
    Call SendDtFunc("TS")                       'Measurement: 1 Sweep & wait
    
    Call SendDtFunc("IQP?")                     'Trace Points
    IQptsbuf = Space(15)
    IQptsbuf = RcvDtFunc
    IQpts = IQptsbuf                            'String to Long
    
    Call SendDtFunc("DLIM2")                    'Delimiter EOI
    
    Call SendDtFunc("IQB?")                     'Trace Data ?
    
    Erase bTrc
    Do While (Form1.tcpClient.BytesReceived < IQpts * 8)    'Data end?
        DoEvents
    Loop
    
    Form1.tcpClient.GetData bTrc                'Get Data (Bytes)
    
    DataCnt = 0                                 'I & Q Data counter
    
    For i = 0 To ((IQpts - 1) * 8) Step 8       'I & Q data = 8 Bytes
    
'        TempBuf = bTrc(i)                       'I data: a,b,c,d --> d,c,b,a
'        bTrc(i) = bTrc(i + 3)
'        bTrc(i + 3) = TempBuf
'
'        TempBuf = bTrc(i + 1)
'        bTrc(i + 1) = bTrc(i + 2)
'        bTrc(i + 2) = TempBuf
        
        Call CopyValtoVal(TrIQ(DataCnt, 0), bTrc(i), IEEE_FLOAT_BYTE)
        
        '-----
'        TempBuf = bTrc(i + 4)                   'Q data: a,b,c,d --> d,c,b,a
'        bTrc(i + 4) = bTrc(i + 7)
'        bTrc(i + 7) = TempBuf
'
'        TempBuf = bTrc(i + 5)
'        bTrc(i + 5) = bTrc(i + 6)
'        bTrc(i + 6) = TempBuf
        
        Call CopyValtoVal(TrIQ(DataCnt, 1), bTrc(i + 4), IEEE_FLOAT_BYTE)
        
        DataCnt = DataCnt + 1                   'Next Data Counter
               
    Next i
    
    '-------------------------------------------'Message Display
    Form1.lstRecv.AddItem Form1.tcpClient.RemoteHost & "-->" & "Get IQ Data"
    Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
    If Form1.lstRecv.ListCount > 100 Then
        Form1.lstRecv.RemoveItem 0
    End If

    '--------------------------------------------------------------
    DspStep = IQpts / 10000                     'Display Resolution
    If DspStep = 0 Then DspStep = 1
    
    Text1.Text = IQpts                          'Samples
    Text2.Text = DspStep                        'Display step data
    DoEvents
    
    For i = 0 To (IQpts - 1) Step DspStep

        RichTextBox1.SelText = i & " :  " & TrIQ(i, 0) & vbCrLf

        RichTextBox2.SelText = i & " :  " & TrIQ(i, 1) & vbCrLf
        
    Next i
    
    '------------------------------------------------------------------------------

    Call SendDtFunc("DLIM0")                    'Delimiter CRLF
    
    Call SendDtFunc("CONTS")                    'Cont Sweep
    
    '-------------------------------------------'Message Display
    Form1.lstRecv.AddItem "----->" & "End of Getting Data, Coverting & Display"
    Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
    If Form1.lstRecv.ListCount > 100 Then
        Form1.lstRecv.RemoveItem 0
    End If

    
Else

    MsgBox "Please open the LAN: Connect button..."

End If



End Sub


Private Sub tcpClient_Close()
'ڑؒf܂
    sbrMessage.SimpleText = "Closed"
    sbrMessage.Refresh
End Sub


Private Sub tcpClient_Connect()
'ڑ܂
Dim Sp As String
Dim SendDt As String, ErrRet As Integer

    sbrMessage.SimpleText = "Connected with " & _
                      tcpClient.RemoteHost & ":" & _
                      tcpClient.RemotePort
    sbrMessage.Refresh
    txtSend.SetFocus
    cmdSend.Enabled = True
    cmdSend.Default = True

'    Do While (tcpClient.BytesReceived = 0)
'        DoEvents
'    Loop
'    tcpClient.GetData Sp
'    lstRecv.AddItem tcpClient.RemoteHost & "-->" & Sp
End Sub

Private Sub tcpClient_ConnectionRequest(ByVal requestID As Long)
Debug.Print "ConnectionReques", requestID

End Sub

Private Sub tcpClient_DataArrival(ByVal bytesTotal As Long)
'f[^͂܂
    Dim strBuf      As String
'AvP[V̑Mf[^擾܂
'    tcpClient.GetData strBuf
'    repData = strBuf
'    lstRecv.AddItem tcpClient.RemoteHost & "-->" & strBuf
'    lstRecv.ListIndex = lstRecv.ListCount - 1
End Sub

Private Sub tcpClient_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
Debug.Print "Error", Number, Description, Source

End Sub

Private Sub tcpClient_SendComplete()
'Debug.Print "SendComplete"

End Sub

Private Sub tcpClient_SendProgress(ByVal bytesSent As Long, ByVal bytesRemaining As Long)
'Debug.Print "SendProgress"

End Sub
